/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.curiosities.symmetry.SymmetryEffectPacket;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandScreen;
import com.simibubi.create.content.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3614;
import net.minecraft.class_3726;

public class SymmetryWandItem
extends class_1792 {
    public static final String SYMMETRY = "symmetry";
    private static final String ENABLE = "enable";

    public SymmetryWandItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        if (player == null) {
            return class_1269.field_5811;
        }
        player.method_7357().method_7906((class_1792)this, 5);
        class_1799 wand = player.method_5998(context.method_20287());
        SymmetryWandItem.checkNBT(wand);
        if (player.method_5715()) {
            if (player.field_6002.field_9236) {
                EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.openWandGUI(wand, context.method_20287()));
                player.method_7357().method_7906((class_1792)this, 5);
            }
            return class_1269.field_5812;
        }
        if (context.method_8045().field_9236 || context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5812;
        }
        class_2487 compound = wand.method_7969().method_10562(SYMMETRY);
        pos = pos.method_10093(context.method_8038());
        SymmetryMirror previousElement = SymmetryMirror.fromNBT(compound);
        wand.method_7969().method_10556(ENABLE, true);
        class_243 pos3d = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        SymmetryMirror newElement = new PlaneMirror(pos3d);
        if (previousElement instanceof EmptyMirror) {
            newElement.setOrientation(player.method_5735() == class_2350.field_11043 || player.method_5735() == class_2350.field_11035 ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            newElement.enable = true;
            wand.method_7969().method_10556(ENABLE, true);
        } else {
            previousElement.setPosition(pos3d);
            if (previousElement instanceof PlaneMirror) {
                previousElement.setOrientation(player.method_5735() == class_2350.field_11043 || player.method_5735() == class_2350.field_11035 ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            }
            if (previousElement instanceof CrossPlaneMirror) {
                float rotation = player.method_5791();
                float abs = Math.abs(rotation % 90.0f);
                boolean diagonal = abs > 22.0f && abs < 67.0f;
                previousElement.setOrientation(diagonal ? CrossPlaneMirror.Align.D.ordinal() : CrossPlaneMirror.Align.Y.ordinal());
            }
            newElement = previousElement;
        }
        compound = newElement.writeToNbt();
        wand.method_7969().method_10566(SYMMETRY, (class_2520)compound);
        player.method_6122(context.method_20287(), wand);
        return class_1269.field_5812;
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 wand = playerIn.method_5998(handIn);
        SymmetryWandItem.checkNBT(wand);
        if (playerIn.method_5715()) {
            if (worldIn.field_9236) {
                EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.openWandGUI(playerIn.method_5998(handIn), handIn));
                playerIn.method_7357().method_7906((class_1792)this, 5);
            }
            return new class_1271(class_1269.field_5812, (Object)wand);
        }
        wand.method_7969().method_10556(ENABLE, false);
        return new class_1271(class_1269.field_5812, (Object)wand);
    }

    @Environment(value=EnvType.CLIENT)
    private void openWandGUI(class_1799 wand, class_1268 hand) {
        ScreenOpener.open(new SymmetryWandScreen(wand, hand));
    }

    private static void checkNBT(class_1799 wand) {
        if (!wand.method_7985() || !wand.method_7969().method_10545(SYMMETRY)) {
            wand.method_7980(new class_2487());
            wand.method_7969().method_10566(SYMMETRY, (class_2520)new EmptyMirror(new class_243(0.0, 0.0, 0.0)).writeToNbt());
            wand.method_7969().method_10556(ENABLE, false);
        }
    }

    public static boolean isEnabled(class_1799 stack) {
        SymmetryWandItem.checkNBT(stack);
        class_2487 tag = stack.method_7969();
        return tag.method_10577(ENABLE) && !tag.method_10577("Simulate");
    }

    public static SymmetryMirror getMirror(class_1799 stack) {
        SymmetryWandItem.checkNBT(stack);
        return SymmetryMirror.fromNBT(stack.method_7969().method_10562(SYMMETRY));
    }

    public static void configureSettings(class_1799 stack, SymmetryMirror mirror) {
        SymmetryWandItem.checkNBT(stack);
        stack.method_7969().method_10566(SYMMETRY, (class_2520)mirror.writeToNbt());
    }

    public static void apply(class_1937 world, class_1799 wand, class_1657 player, class_2338 pos, class_2680 block) {
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        if (!class_1747.field_8003.containsKey(block.method_26204())) {
            return;
        }
        HashMap<class_2338, class_2680> blockSet = new HashMap<class_2338, class_2680>();
        blockSet.put(pos, block);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.method_7969().method_10562(SYMMETRY));
        class_243 mirrorPos = symmetry.getPosition();
        if (mirrorPos.method_1022(class_243.method_24954((class_2382)pos)) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        if (!player.method_7337() && SymmetryWandItem.isHoldingBlock(player, block) && BlockHelper.findAndRemoveInInventory(block, player, 1) == 0) {
            return;
        }
        symmetry.process(blockSet);
        class_2338 to = new class_2338(mirrorPos);
        ArrayList<class_2338> targets = new ArrayList<class_2338>();
        targets.add(pos);
        for (class_2338 position : blockSet.keySet()) {
            if (position.equals((Object)pos) || !world.method_8628(block, position, class_3726.method_16195((class_1297)player))) continue;
            class_2680 blockState = (class_2680)blockSet.get(position);
            for (class_2350 face : Iterate.directions) {
                blockState = blockState.method_26191(face, world.method_8320(position.method_10093(face)), (class_1936)world, position, position.method_10093(face));
            }
            if (player.method_7337()) {
                world.method_8501(position, blockState);
                targets.add(position);
                continue;
            }
            class_2680 toReplace = world.method_8320(position);
            if (!toReplace.method_26207().method_15800() || toReplace.method_26214((class_1922)world, position) == -1.0f) continue;
            if (AllBlocks.CART_ASSEMBLER.has(blockState)) {
                class_2680 railBlock = CartAssemblerBlock.getRailBlock(blockState);
                if (BlockHelper.findAndRemoveInInventory(railBlock, player, 1) == 0) continue;
                if (BlockHelper.findAndRemoveInInventory(blockState, player, 1) == 0) {
                    blockState = railBlock;
                }
            } else if (BlockHelper.findAndRemoveInInventory(blockState, player, 1) == 0) continue;
            class_2680 cachedState = world.method_8320(position);
            class_3610 ifluidstate = world.method_8316(position);
            world.method_8652(position, ifluidstate.method_15759(), 16);
            world.method_8501(position, blockState);
            class_2487 wandNbt = wand.method_7948();
            wandNbt.method_10556("Simulate", true);
            boolean placeInterrupted = !world.method_8628(cachedState, position, class_3726.method_16194());
            wandNbt.method_10556("Simulate", false);
            if (placeInterrupted) {
                world.method_8501(position, cachedState);
                continue;
            }
            targets.add(position);
        }
        AllPackets.channel.sendToClientsTrackingAndSelf((S2CPacket)new SymmetryEffectPacket(to, targets), (class_1297)player);
    }

    private static boolean isHoldingBlock(class_1657 player, class_2680 block) {
        class_1799 itemBlock = BlockHelper.getRequiredItem(block);
        return player.method_6047().method_7962(itemBlock) || player.method_6079().method_7962(itemBlock);
    }

    public static void remove(class_1937 world, class_1799 wand, class_1657 player, class_2338 pos, class_2680 ogBlock) {
        class_2680 air = class_2246.field_10124.method_9564();
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        HashMap<class_2338, class_2680> blockSet = new HashMap<class_2338, class_2680>();
        blockSet.put(pos, air);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.method_7969().method_10562(SYMMETRY));
        class_243 mirrorPos = symmetry.getPosition();
        if (mirrorPos.method_1022(class_243.method_24954((class_2382)pos)) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        symmetry.process(blockSet);
        class_2338 to = new class_2338(mirrorPos);
        ArrayList<class_2338> targets = new ArrayList<class_2338>();
        targets.add(pos);
        for (class_2338 position : blockSet.keySet()) {
            class_2586 be;
            class_2680 blockstate = world.method_8320(position);
            if (!player.method_7337() && ogBlock.method_26204() != blockstate.method_26204() || position.equals((Object)pos) || blockstate.method_26207() == class_3614.field_15959) continue;
            class_2586 class_25862 = be = blockstate.method_31709() ? world.method_8321(pos) : null;
            if (SymmetryWandItem.handlePreEvent(world, player, position, blockstate, be)) continue;
            targets.add(position);
            world.method_20290(2001, position, class_2248.method_9507((class_2680)blockstate));
            world.method_8652(position, air, 3);
            if (!player.method_7337()) {
                if (!player.method_6047().method_7960()) {
                    player.method_6047().method_7952(world, blockstate, position, player);
                }
                class_2586 tileentity = blockstate.method_31709() ? world.method_8321(position) : null;
                class_2248.method_9511((class_2680)blockstate, (class_1937)world, (class_2338)pos, (class_2586)tileentity, (class_1297)player, (class_1799)player.method_6047());
            }
            SymmetryWandItem.handlePostEvent(world, player, position, blockstate, be);
        }
        AllPackets.channel.sendToClientsTrackingAndSelf((S2CPacket)new SymmetryEffectPacket(to, targets), (class_1297)player);
    }

    public static boolean handlePreEvent(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 be) {
        if (((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(world, player, pos, state, be)) {
            return false;
        }
        ((PlayerBlockBreakEvents.Canceled)PlayerBlockBreakEvents.CANCELED.invoker()).onBlockBreakCanceled(world, player, pos, state, be);
        return true;
    }

    public static void handlePostEvent(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 be) {
        ((PlayerBlockBreakEvents.After)PlayerBlockBreakEvents.AFTER.invoker()).afterBlockBreak(world, player, pos, state, be);
    }
}

